;Die Runtime-Routinen       (SYSTEM48.ASM)
;RS232 Senden bei 6 MHz, verwendet r2...r3
;9600 Baud, Sendesignal liegt invertiert an P27

.org 0009h

Senden         mov     r2,#8          ;Zhlschleife 8 Bits
               anl     p2,#7Fh        ;P27=0, Startbit
;              mov     r3,#162        ;1200Baud
               mov     r3,#16         ;9600 Baud
Sch1           djnz    r3,Sch1        ;Warteschleife Startbit
Sp1            clr     c
               rrc     a              ;Datenbit in C schieben
               jc      Sp2
               anl     p2,#7Fh        ;wenn c=0, dann P27=0
               jnc     Sp3
Sp2            orl     p2,#80h        ;wenn c=1, dann P27=1
               orl     p2,#80h
;Sp3            mov     r3,#160       ;1200Baud
Sp3            mov     r3,#15         ;9600 Baud
Sch2           djnz    r3,Sch2        ;Warteschleife Datenbit
               djnz    r2,Sp1         ;8 mal wiederholen
               mov     a,#0
               mov     a,#0
               orl     p2,#80h        ;P27=1, Stopbit
;               mov     r3,#108       ;1200 Baud
               mov     r3,#1          ;kurzes Stopbit, 9600 Ba
Sch3           djnz    r3,Sch3        ;Warteschleife Stopbit
               ret

;RS232 Empfangen, verwendet r2...r4
;Eingang ist INT mit Abfrage ber jni. Baudrate 9600 bei 6MHz

Empf           jni     Startbit       ;Int = 0?
               clr     c
               jnc     Empf           ;wenn Int = 1
;Startbit       mov     r2,#225       ;1200 Baud
Startbit       mov     r2,#25         ;9600 Baud
Sch6           djnz    r2,Sch6        ;Warten 1,5 Startbit
               mov     r3,#8          ;Schleife 8 Bits
Sp6            clr     c              ;c=0
               jni     Null           ;Int = 0 ?
               nop                    ;Zeitausgleich
               cpl     c              ;C=1
               xch     a,r4           ;Byte von r4 holen
               rrc     a              ;c in a schieben
               xch     a,r4           ;Byte wieder nach r4
;               mov     r2,#162       ;1200 Baud
               mov     r2,#15         ;9600 Baud
Sch7           djnz    r2,Sch7        ;Warten Datenbit
               djnz    r3,Sp6         ;8 Bits empfangen?
               mov     a,r4           ;empfangenes Byte in a
               ret
Null           nop                    ;Schleife fr Nullbits:
               clr     c              ;c=0
               xch     a,r4           ;Byte von r4 holen
               rrc     a              ;c in a schieben
               xch     a,r4           ;Byte wieder nach r4
;               mov     r2,#162       ;1200 Baud
               mov     r2,#15         ;9600 Baud
Sch8           djnz    r2,Sch8        ;Warten Datenbit
               djnz    r3,Sp6         ;8 Bits empfangen?
               mov     a,r4           ;empfangenes Byte in a
               ret

;Wartezeit bis zur nchsten abgelaufenen Millisekunde

Warte          mov     r5,a
Warten         jtf     end1ms          ;Timer-berlauf?
               clr     c
               jnc     Warten
end1ms         mov     r6,a
               mov     a,#244          ;1ms/6MHz
               mov     t,a
               mov     a,#0            ;Feinabgleich
               mov     a,#0
               mov     a,#0
               mov     a,#0
               mov     a,r6
               strt    t               ;Timer-Neustart
               djnz    r5,Warten
               ret
.end
