Program Relais;
uses DOS, CRT;
const COM1: Integer=$03F8;
      COM2: Integer=$02F8;
      COM3: Integer=$03E8;
      COM4: Integer=$02E8;
var   BA: Integer;

procedure Init (COM: Integer);
var i, Dummy: Byte;
begin
  BA:= COM;
  Port[BA+3]:=128;
  Port[BA+0]:=12; {9600 Baud}
  Port[BA+1]:=0;
  Port[BA+3]:=7;  {8 Bit, n-Parity, 2 Stopbits}
  Port[BA+1]:=0;  {keine Interrupts}
  Port[BA+4]:=0;  {DTR=0, RTS=0}
  for i:= 1 to 3 do Dummy:= Port[BA]; {UART leeren}
end;

procedure Sende (Zeichen:Byte);
begin
  while (Port[BA+5] AND 32)=0 do; {bereit?}
  Port[BA]:= Zeichen;
end;

procedure Adresse_zuweisen (Adr: Byte);
begin
  Sende (27);
  Sende (255); {Senden an alle}
  Sende (72);  {Kommando: ID-Adresse Zuweisen}
  Sende (Adr);
  Sende (0);
end;

procedure Ausgabe (Adr, Dat: Byte);
begin
  Sende (27);
  Sende (Adr);
  Sende (64);  {Kommando: Direktausgabe}
  Sende (Dat);
  Sende (0);
end;

procedure Programmiere (Adr, EEadr, Dat: Byte);
begin
  Sende (27);
  Sende (Adr);
  Sende (66);  {Kommando: EEPROM programmieren}
  Sende (EEadr);
  Sende (Dat);
end;

procedure Programmstart_Endlos (Adr: Byte);
begin
  Sende (27);
  Sende (Adr);
  Sende (68);  {Kommando: Start, endlos}
  Sende (0);
  Sende (0);
end;

procedure Programmstart_Einfach (Adr: Byte);
begin
  Sende (27);
  Sende (Adr);
  Sende (74);  {Kommando: Start, einfach}
  Sende (0);
  Sende (0);
end;

procedure Programmstop (Adr: Byte);
begin
  Sende (27);
  Sende (Adr);
  Sende (70);  {Kommando: Stop}
  Sende (0);
  Sende (0);
end;


procedure Lauflicht;
begin
  Ausgabe (1,1); Delay (250);
  Ausgabe (1,2); Delay (250);
  Ausgabe (1,4); Delay (250);
  Ausgabe (1,8); Delay (250);
  Ausgabe (1,16); Delay (250);
  Ausgabe (1,32); Delay (250);
  Ausgabe (1,64); Delay (250);
  Ausgabe (1,128); Delay (250);
end;

procedure ProgrammTest;
begin
  ProgrammStop (1);
  Programmiere (1,2,0); {Zeitbasis Highbyte}
  Programmiere (1,3,8); {Zeitbasis Lowbyte, 1/2 s}
  Programmiere (1,4,85); {Bitmuster 1}
  Programmiere (1,5,1); {1 Zeiteinheit}
  Programmiere (1,6,170); {Bitmuster 2}
  Programmiere (1,7,1); {1 Zeiteinheit}
  Programmiere (1,8,170); {Bitmuster 1}
  Programmiere (1,9,0); {Ende der Schleife}
end;



begin;
  Init(COM2);
  writeln ('Relais-Interface, ID-Adresse 1');
  writeln ('TestProgramm starten');
  ProgrammTest;
  Programmstart_endlos(1);
end.
