//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "compulab_usb.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

unsigned char Ausgabe[4], Eingabe[8];
unsigned char DigitalAusgang = 0;
HANDLE Datei;
unsigned long n;

//---------------------------------------------------------------------------
bool _fastcall USB_existiert(void) // testet, ob CompulabUSB angeschlossen ist
 {
 Datei = CreateFile(USB_Dateiname, GENERIC_WRITE, FILE_SHARE_WRITE,
  NULL, OPEN_EXISTING, 0, 0);
 if(Datei != INVALID_HANDLE_VALUE)
  {
  Ausgabe[0] = 23; // AD Startkanal festlegen
  Ausgabe[1] = 0x34;
  Ausgabe[2] = 0x80;
  DeviceIoControl((void*)Datei, 0x04,
   Ausgabe, sizeof(Ausgabe), Eingabe, sizeof(Eingabe), &n, NULL);
  CloseHandle(Datei);
  return ja;
  }
 return nein;
 }
//---------------------------------------------------------------------------
double _fastcall USB_A_lesen(void) // liest Analogeingang A (von 0 bis 1)
 {
 Datei = CreateFile(USB_Dateiname, GENERIC_WRITE, FILE_SHARE_WRITE,
  NULL, OPEN_EXISTING, 0, 0);
 if(Datei != INVALID_HANDLE_VALUE)
  {
  Ausgabe[0] = 6;
  Ausgabe[1] = DigitalAusgang;
  DeviceIoControl((void*)Datei, 0x08,
   Ausgabe, sizeof(Ausgabe), Eingabe, sizeof(Eingabe), &n, NULL);
  CloseHandle(Datei);
  return ((double)((Eingabe[2] << 2) + (Eingabe[4] & 3))) / 1023.;
  }
 return 0.;
 }
//---------------------------------------------------------------------------
double _fastcall USB_B_lesen(void) // liest Analogeingang B (von 0 bis 1)
 {
 Datei = CreateFile(USB_Dateiname, GENERIC_WRITE, FILE_SHARE_WRITE,
  NULL, OPEN_EXISTING, 0, 0);
 if(Datei != INVALID_HANDLE_VALUE)
  {
  Ausgabe[0] = 6;
  Ausgabe[1] = DigitalAusgang;
  DeviceIoControl((void*)Datei, 0x08,
   Ausgabe, sizeof(Ausgabe), Eingabe, sizeof(Eingabe), &n, NULL);
  CloseHandle(Datei);
  return ((double)((Eingabe[3] << 2) + (Eingabe[4] >> 4 & 3))) / 1023.;
  }
 return 0.;
 }
//---------------------------------------------------------------------------
unsigned char _fastcall USB_D_lesen(void) // liest 8 bit vom Digitaleingang
 {
 Datei = CreateFile(USB_Dateiname, GENERIC_WRITE, FILE_SHARE_WRITE,
  NULL, OPEN_EXISTING, 0, 0);
 if(Datei != INVALID_HANDLE_VALUE)
  {
  Ausgabe[0] = 6;
  Ausgabe[1] = DigitalAusgang;
  DeviceIoControl((void*)Datei, 0x08,
   Ausgabe, sizeof(Ausgabe), Eingabe, sizeof(Eingabe), &n, NULL);
  CloseHandle(Datei);
  return Eingabe[1];
  }
 return 0;
 }
//---------------------------------------------------------------------------
void _fastcall USB_D_schreiben(unsigned char Daten) // schreibt 8 bit
 // zum Digitalausgang
 {
 Datei = CreateFile(USB_Dateiname, GENERIC_WRITE, FILE_SHARE_WRITE,
  NULL, OPEN_EXISTING, 0, 0);
 if(Datei != INVALID_HANDLE_VALUE)
  {
  Ausgabe[0] = 6;
  Ausgabe[1] = DigitalAusgang = Daten;
  DeviceIoControl((void*)Datei, 0x08,
   Ausgabe, sizeof(Ausgabe), Eingabe, sizeof(Eingabe), &n, NULL);
  CloseHandle(Datei);
  }
 }
//---------------------------------------------------------------------------

